﻿var language;
var i;
var j;
var id;
var slotNum = 5;	//默认为主板页面
/**************************************
版本号：V4.0.7
修改时间：2013.10.18
修改说明：1、该版本自适应QAM卡类型，支持QT241，QT242，QT083
		2、添加告警屏蔽网页
**************************************
版本号：V4.0.8
修改时间：2014.01.10
修改说明：1、告警屏蔽页面添加网关不可达等告警类型
		2、卡频点设置页面，控件显示属性和读写属性从主控获取
***************************************
版本号：V4.0.9
修改时间：2014.02.09
修改说明：1、更新主页面版权时间显示
		2、修改重启锁频解锁后，状态值未清零的bug
***************************************
版本号：V4.0.10
修改时间：2014.02.19
修改说明：1、该版本网页支持C518卡。
**************************************
版本号：V4.1.1
修改时间：2014.05.28
修改说明：1、该版本网页支持万兆
**************************************/
var WEB_VERSION = "V4.2.6";

function fillVerTable(data)
{
	var sysAbout = data.split("&");
	var ControlName = new Array("slot_", "type_", "app_version_", "bsp_version_", "fpga_version_", "hardware_version_", "serial_no_");
	
	for(i = 0; i < ControlName.length; i++)
	{
		var indexPos = sysAbout[i].split(",");
		for(j = 0; j < slotNum; j++)
		{
			id = j + 1;
			document.getElementById(ControlName[i] + id).innerHTML = indexPos[j];
			if((i == 1) && (j > 0))
			{
				if(indexPos[j] == "N/A")
				{
					document.getElementById("web_version_" + id).innerHTML = "N/A";
				}
				else
				{
					document.getElementById("web_version_" + id).innerHTML = WEB_VERSION;
				}
			}
		}
	}
	
	document.getElementById("web_version_1").innerHTML = WEB_VERSION;
	document.getElementById("ip_address").innerHTML = sysAbout[i++];
	document.getElementById("subnet_mask").innerHTML = sysAbout[i++];
	document.getElementById("mac_address").innerHTML = sysAbout[i++];
	document.getElementById("default_gateway").innerHTML = sysAbout[i++];
}

function restoreSysAbout()
{
	var xmlhttp = false;
	var Response;
	var getParams = "type=16&cmd=1&getSystemAbout=1&language=" + language;
	
	xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				Response = gb2utf8(xmlhttp.responseBody);
				var index = Response.indexOf("</html>");
				var bias = Response.length - index;
				Response = Response.slice(7, - bias);
			}
			else
			{
				Response = xmlhttp.responseText.slice(7, -8);
			}
			
			fillVerTable(Response);
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function adjustTable(slotNum)
{
	var verTable = document.getElementById("ver_table");
	var tBody = verTable.children[1];
	
	if(slotNum < 3)
	{
		document.getElementById("div_body").style.width = "500px";
		document.getElementById("div_tab").style.width = "480px";
		tBody.children[0].children[0].style.width = "30%";
		document.getElementById("ip_head").style.width = "30%";	
	}
	else if(slotNum == 5)
	{
		return;
	}
	
	for(i=5,j=slotNum; i>j; i--)
	{
		for(k=0; k<8; k++)
		{
			tBody.children[k].children[i].style.display = "none";
		}
	}
	document.getElementById("ver_head").colSpan = parseInt(slotNum + 1);
	
	var per;
	switch(slotNum)
	{
		case 4:
			per = 20;
			break;
		case 3:
			per = 26;
			break;
		case 2:
			per = 35;
			break;
		case 1:
			per = 70;
			break;
		default:
			per = 16;
			break;
	}
	for(i=1; i<=slotNum; i++)
	{
		tBody.children[0].children[i].style.width = per + "%";
	}
	if(slotNum == 3)
	{
		tBody.children[0].children[3].style.width = "28%";
	}
}

function getSlotNum()
{
	var getParams = "type=16&cmd=1&getSlotNum=1";
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			slotNum = parseInt(xmlhttp.responseText.slice(7, -8));
			adjustTable(slotNum);
		}
	}
	
	xmlhttp.send(getParams);
	return true;
}

window.onload = function()
{
	language = document.getElementById("language").value;
	getSlotNum();
	restoreSysAbout();
}